/*------------------------------------------------------------------------------*
 * File Name: XFDialog.h														*
 * Creation: CPY 1/14/2005														*
 * Purpose: X-Function tool														*
 * Copyright (c) OriginLab Corp. 2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 1/19/2005 MAIN_MENU_DLG_OC_HANDLING										*
 *	ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH							*
 *  Iris 3/31/05 ADD_RECENT_FILE_LIST											*
 *  Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU						*
 *	YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG							*
 *	Jasmine 01/24/06 v8.0361 SHOW_XF_CONTEXT_MENU								*
 *	AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS										*
 *	Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR								*
 *	TD 08-13-2007 SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION*
 *	Folger 08/16/07 ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU						*
 *	Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF					*
 *	Hong 01/18/08 v8.0788 FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY	*
 *	Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU						*
 *	YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS									*
 *	Folger 05/25/09 QA80-13664 XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
 *	Folger 09/01/09 ADD_NUMERIC_SHORTCUT_FOR_XF_DIALOG_MRU_MENU					*
 *------------------------------------------------------------------------------*/
 
#ifndef _XF_DLG_H
#define _XF_DLG_H

#define BASE_WINDOW MultiPaneDlg
#include "TreeEditEvents.h"

/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
#define ON_COMPILER_MSG(_fn)								msgMap.AddDirectWndMsg(WM_USER_XFC_ON_FINISH_COMPILE, ID_DLG, _fn, VTS_PI2 VTS_I4, MHO_BEFORE);						
#define ON_OC_DOC_SAVE(_fn)					msgMap.AddDirectWndMsg(WM_USER_XFC_DOC_SAVE, ID_DLG, _fn, VTS_RORIGINOBJ VTS_PI4, MHO_BEFORE);						
/// end  XFUNCTION_IDE

enum {
	XFMODE_EXTERNAL,
	XFMODE_INTERNAL_EDITING,
	XFMODE_INTERNAL_NORMAL,// not in editing
XFMODE_INTERNAL_LAST_ENTRY};




///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
#define VARIABLE_PANE_MAX_SIZE		95
#define VARIABLE_PANE_MIN_SIZE		5
#define VARIABLE_PANE_STEP_INCRE	10
#define VARI_PANE_REG_NAME		"VariablePaneSize"
///End	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU

/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
#define STR_INI_SECTION_XF_RECENT_FILE		"XFRecentFileList"

#define	MAKE_SIMPER_XF_DLG  /// Iris 05/28/2007 v8.0628 MAKE_XF_DLG_SIMPLER

class XFMRFList : public MRFList
{
public:
	XFMRFList() {}
public:
	string	GetDisplayName(int nIndex =0, bool bRemoveVerboseInfo = true )
	{
		string strFileName = Get(nIndex);
		
		string strDisplayName = okutil_composite_name_from_file_path(strFileName, m_strSubPath);
		
		//string strUserPrefix = "User:";
		
		///DSC 8/4/05 KEEP_FULL_COMPOSITE_NAME
		/*if(bRemoveVerboseInfo)
		{
			///Remove verbose information.
			int nStartRemove, nEndRemove;
			nStartRemove = strDisplayName.Find("(");
			nEndRemove   = strDisplayName.Find(")");
			//if(strDisplayName.Find(strUserPrefix) == 0)
				//nStartRemove = 0;
			strDisplayName.Delete(nStartRemove, nEndRemove - nStartRemove +1);
			
			strDisplayName.TrimLeft();
		}
		*/
		///end KEEP_FULL_COMPOSITE_NAME
		///------ Folger 09/01/09 ADD_NUMERIC_SHORTCUT_FOR_XF_DIALOG_MRU_MENU
		string	strTmp = strDisplayName;
		strDisplayName.Format("&%d %s", (nIndex + 1) %10, strTmp);
		///------ End ADD_NUMERIC_SHORTCUT_FOR_XF_DIALOG_MRU_MENU
		return strDisplayName;
	
	}
};
/// END ADD_RECENT_FILE_LIST_CLASS


//---- CPY 2/15/05 USE_FUNC_FILE_NAME_TO_INDICATE_NEW double storage, no need for separate attribute, just use FuncFileName in base class to indicate
//#define STR_NEW_FUNCTION_ATTRIB		"New"	///DG 2/4/05 : indicate this is new function
//----
class XFunctionDlg : public TreeEditDlg
{
public:
	XFunctionDlg() : TreeEditDlg( IDD_XF, "oDlg8" )
	{
		/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
		/*
		m_bViewAdvanced = false;
		m_nInternalMode = XFMODE_EXTERNAL;
		m_uidCurrentOp = 0;
		*/
		Reset();
		/// end XFOPERATION_CHANGE_PARAM
	}	
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//invalidateStats();
		//Launch the modeless dialog
		int nRet = TreeEditDlg::Create(hParent);		
		Visible=true;	///DG 1/26/05 first open dialog not show, just try if this works
		return nRet;
	}
	
	
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	void	UpdateTreeAfterChangeParamOk(TreeNode& tr);
	bool	PrepareForChangeParamOperation(TreeNode& trXF, uint uid);
	int		DoModalEx();
	void	Reset();
	BOOL	IsChangeParamOk()	{return m_bChangeParamOk;}
	/// end XFOPERATION_CHANGE_PARAM
	
	// inline implemneted simple functions
protected:
	BOOL OnToggleViewTree()
	{
		setViewAdvanced();
		return true;
	}
	BOOL OnUiUpdateViewTree(CmdUI cmd)
	{
		cmd.SetCheck(m_bViewAdvanced);
		return TRUE;
	}
	BOOL OnUiUpdateInternalMode(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
				
		cmd.SetCheck(isInternalXF());
		return TRUE;
	}
	BOOL OnUiUpdateExternalMode(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		cmd.SetCheck(!isInternalXF());
		return TRUE;
	}
	BOOL OnUiUpdateDisableInternalChanged(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		bool bEnable = true;
		if(isInternalXF() && isXFChanged())
			bEnable = false;
		cmd.Enable(bEnable);
		return TRUE;
	}
	BOOL OnUiUpdateDisableInternalChangedOrEmpty(CmdUI cmd)
	{
		bool bEnable = true;
		if(isInternalXF() && isXFChanged())
			bEnable = false;
		if(bEnable && isXFEmpty())
			bEnable = false;
		cmd.Enable(bEnable);
		return TRUE;
	}
	BOOL OnUiUpdateDisableInternal(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG

		cmd.Enable(!isInternalXF());
		return TRUE;
	}
	BOOL OnUiUpdateDisableInternalOrSystemPath(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		bool bEnable = !isInternalXF();
		if(bEnable && getPathType() == ORIGIN_PATH_SYSTEM)
			bEnable = false;
			
		cmd.Enable(bEnable);
		return TRUE;
	}
	BOOL OnUiUpdateDisableExternalOrNotDirty(CmdUI cmd)
	{
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		if( CheckDisableIfChangeParam(cmd) )
			return TRUE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		bool bEnable = isInternalXF();
		if(!isXFChanged())
			bEnable = false;
			
		cmd.Enable(bEnable);
		return TRUE;
	}
	
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	BOOL	CheckDisableIfChangeParam(CmdUI cmd)
	{
		if( m_bChangeParam )
		{
			cmd.Enable(FALSE);
			return TRUE;
		}
		
		return FALSE;
	}
	
	BOOL	OnUiUpdateXFNew(CmdUI cmd)
	{
		CheckDisableIfChangeParam(cmd);
		return TRUE;
	}
	BOOL	OnUiUpdateXFWizard(CmdUI cmd)
	{
		CheckDisableIfChangeParam(cmd);
		return TRUE;
	}
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
protected:
	BOOL OnDestroy(void);
	void OnRowColChange(Control cntrl)
	{
		if(!IsInitReady())
			return;
		TreeEditDlg::OnRowColChange(cntrl);
	}	
	// get the name of the page
	BOOL OnActivePageChange( void )
	{
		if(!IsInitReady())
			return TRUE;

		return TRUE;
	}
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_DESTROY(OnDestroy)
	ON_CANCEL(OnCancel)
	ON_CHANGE_LAYER( OnActiveLayerChange )
	ON_CHANGE_PAGE( OnActivePageChange )
	
	ON_CMD_UI_UPDATE(IDC_XFM_VIEW_TREE, OnUiUpdateViewTree)	
	ON_CMD_UI_UPDATE(IDC_XFM_INTERNAL_MODE, OnUiUpdateInternalMode)	
	ON_CMD_UI_UPDATE(IDC_XFM_EXTERNAL_MODE, OnUiUpdateExternalMode)	
	ON_CMD_UI_UPDATE(IDC_XFM_MAKE_INTERNAL, OnUiUpdateDisableInternal)	
	ON_CMD_UI_UPDATE(IDC_XFM_OPEN, OnUiUpdateDisableInternalChanged)	
	ON_CMD_UI_UPDATE(IDC_XFM_OPEN_SAMPLES, OnUiUpdateDisableInternalChanged)	
	ON_CMD_UI_UPDATE(IDC_XFM_SAVE, OnUiUpdateDisableInternalOrSystemPath)	
	ON_CMD_UI_UPDATE(IDC_XFM_SAVE_AS, OnUiUpdateDisableInternalChangedOrEmpty)	
	ON_CMD_UI_UPDATE(IDC_XFM_CANCEL_INTERNAL, OnUiUpdateDisableExternalOrNotDirty)	
	ON_CMD_UI_UPDATE(IDC_XFM_UPDATE_INTERNAL, OnUiUpdateDisableExternalOrNotDirty)	
	ON_CMD_UI_UPDATE(IDC_XFM_REMOVE_INTERNAL, OnUiUpdateDeleteInternalXF)	
	ON_CMD_UI_UPDATE(IDC_XFM_OC_COMPILE, OnUiUpdateCompile)
	
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	ON_CMD_UI_UPDATE(IDC_XFM_NEW, OnUiUpdateXFNew)
	ON_CMD_UI_UPDATE(IDC_XFM_NEW_WIZARD, OnUiUpdateXFWizard)
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	
	/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
	ON_USER_MSG(WM_USER_XFC_DOC_CLOSE,			OnOCDocClose)
	ON_OC_DOC_SAVE(OnOCDocSave)
	ON_COMPILER_MSG(OnCompilerMessage)
	/// end  XFUNCTION_IDE
	///DG 1/20/05
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
	///Joseph 01/18/07 REMOVE_FUNCTION_BROWER
	//ON_KEY(IDC_XF_OC_EDITOR, OnOCEditorKey)	///DG 1/24
	///End REMOVE_FUNCTION_BROWER
	ON_EN_CHANGE(IDC_XF_OC_EDITOR, OnOCEditorChange)

	ON_TAB_SEL_CHANGE(IDC_XF_BOTTOM_TAB, OnBottomTabChange)

	ON_BN_CLICKED(IDC_XF_SHOW_BOTTOM, OnShowBottomPane)
	ON_BN_CLICKED(IDC_XF_RUN, OnRun)
	ON_BN_CLICKED(IDC_XF_AUTOUPDATE, OnChangeAutoUpdate)
	ON_SIZE(OnDlgResize)
	ON_GETMINMAXINFO(OnMinMaxInfo)	///DG 2/2/05 : for dlg size, limit by code, not by Source size

	ON_MENU_CMD(IDC_XFM_NEW, OnFileNew)
	ON_MENU_CMD(IDC_XFM_NEW_WIZARD, OnNewOpenWizard)
	ON_MENU_CMD(IDC_XFM_OPEN, OnFileOpen)
	ON_MENU_CMD(IDC_XFM_OPEN_USER, OnOpenUser)		//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
	ON_MENU_CMD(IDC_XFM_OPEN_GROUP, OnOpenGroup)	//------ Folger 08/16/07 ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU
	ON_MENU_CMD(IDC_XFM_OPEN_SAMPLES, OnOpenSystem)
	ON_MENU_CMD(IDC_XFM_SAVE, OnFileSave)
	ON_MENU_CMD(IDC_XFM_SAVE_AS, OnFileSaveAs)
	ON_MENU_CMD_RANGE(IDC_RECENT_FILE_LIST_BEGIN, IDC_RECENT_FILE_LIST_END, OnSelMostRecentFileList)  ///Iris 3/31/05 ADD_RECENT_FILE_LIST

	ON_MENU_CMD(IDC_XFM_MAKE_INTERNAL, OnConvertToInternal)
	ON_MENU_CMD(IDC_XFM_CLOSE, OnClose)
	ON_MENU_CMD(IDC_XFM_OC_EDIT, OnEditCodeBuilder)
	ON_MENU_CMD(IDC_XFM_OC_COMPILE, OnCompile)
	
	ON_MENU_CMD(IDC_XFM_VIEW_TREE, OnToggleViewTree)
	ON_MENU_CMD(IDC_XFM_OC_EDIT, OnCodeBuilder) /// TD 2-14-05 QA70-7403 XFUNCTION_IDE
	ON_MENU_CMD(IDC_XFM_INTERNAL_MODE, OnToggleInternalMode)
	ON_MENU_CMD(IDC_XFM_EXTERNAL_MODE, OnToggleInternalMode)

	ON_MENU_CMD(IDC_XFM_CANCEL_INTERNAL, OnCancelInternalEdit)
	ON_MENU_CMD(IDC_XFM_UPDATE_INTERNAL, OnUpdateInternalEdit)
	ON_MENU_CMD(IDC_XFM_REMOVE_INTERNAL, OnDeleteInternalXF)

//	ON_CHANGE_SELECTION( OnSelectionChange )
//	ON_CHANGE_LAYER(OnLayerChange)
//	ON_SELECTION_TRACK(OnSelectionTrack)
//	ON_BN_CLICKED(IDC_INTERACTIVE_POPUP_BTN,  OnInteractivePopUp)
//	ON_BN_CLICKED(IDC_XY_DATARANGE_DLG_BUTTON, OnInteractiveXYDataRange)/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	ON_GETNDLG_MSGS(IDC_XF_TREE)
	ON_GETNDLG_MSGS(IDC_XF_GRID)
	//----
	ON_SYSCOMMAND(OnSystemCommand)
	
	ON_EN_CHANGE(IDC_XF_NAME, OnContentChange)		//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	
	//ON_KEY(IDC_XF_NAME, OnKeyCmdWindow)	///---Frank 4/19/05	FIXED_ENTER_XF_NAME_AND_CODE_LOST
	ON_OK(OnOK)   //--CPY 6/4/05 ON_OK_NEED_TO_PREVENT_CLOSING, to replace Frank 4/19/05	FIXED_ENTER_XF_NAME_AND_CODE_LOST, as enter key is also possible from other places like in grid cell editing
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	ON_BN_CLICKED(IDC_XF_OK,  OnChangeParamOk)
	ON_BN_CLICKED(IDC_XF_CANCEL,  OnChangeParamCancel)
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	/// TD 08-13-2007 SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION
	ON_USER_MSG(WM_USER_DYNACONTROL_OPTIONS,	OnDynacontrolOptions)
	/// end SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION
EVENTS_END

	BOOL	OnFileNew();	///DG 1/20/05
	BOOL	OnNewOpenWizard();	///DG 1/22/05
	BOOL	OnFileSave();
	BOOL	OnFileSaveAs();
	BOOL	OnFileOpen();	/// ML 1/19/2005 MAIN_MENU_DLG_OC_HANDLING
	BOOL	OnOpenUser();		//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
	BOOL	OnOpenGroup();		//------ Folger 08/16/07 ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU
	BOOL	OnOpenSystem();
	BOOL	OnClose();
	BOOL	OnCancel();
	BOOL	OnEditCodeBuilder();
	BOOL 	OnCompile();
	BOOL	OnInteractivePopUp(Control ctrl);
	
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	BOOL	OnChangeParamOk(Control ctrl);
	BOOL	OnChangeParamCancel(Control ctrl);
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	
	BOOL	OnSelectionTrack();
	BOOL	OnInteractiveXYDataRange(Control ctrl);/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	BOOL 	OnCodeBuilder(); /// TD 2-14-05 QA70-7403 XFUNCTION_IDE
	BOOL 	OnToggleInternalMode();
	BOOL	OnUpdateInternalEdit();
	BOOL	OnCancelInternalEdit();
	BOOL	OnDeleteInternalXF();
	BOOL	OnUiUpdateDeleteInternalXF(CmdUI cmd);
	BOOL	OnUiUpdateCompile(CmdUI cmd);
	BOOL 	OnInitDialog();
	BOOL 	OnRun(Control cntrl);
	///------ Folger 05/25/09 QA80-13664 XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
	//BOOL	OnOK(Control cntrl);   //--CPY 6/4/05 ON_OK_NEED_TO_PREVENT_CLOSING
	BOOL	OnOK();   //--CPY 6/4/05 ON_OK_NEED_TO_PREVENT_CLOSING
	///------ End XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
	BOOL 	OnConvertToInternal();
	BOOL 	OnChangeAutoUpdate(Control cntrl);
	BOOL 	OnDlgResize(int nType, int cx, int cy);	
	BOOL	OnBottomTabChange(Control cntrl) {	updateBottomTabDisplay(); return true;}
	// change the selection 
	BOOL OnSelectionChange();
	BOOL OnWksSelectionChange(Worksheet& wks);//--- CPY 3/3/05 INTERNAL_XF_EDIT
	BOOL OnLayerChange();//--- CPY 3/3/05 INTERNAL_XF_EDIT
	BOOL OnActiveLayerChange( );
	
	/// TD 08-13-2007 SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION
	BOOL OnDynacontrolOptions(int nOption, int nUnused);
	/// end SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION
	/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
	BOOL OnOCDocClose(UINT wParam, UINT lParam);
	BOOL OnOCDocSave(StringArray& arrEditables, LPCSTR lpcsz);
	BOOL OnCompilerMessage(LPCSTR  lpcszErr, UINT nLineErr);
	/// end  XFUNCTION_IDE
	void OnAfterValueChange(int nRow, int nCol);
	///Joseph 01/18/07 REMOVE_FUNCTION_BROWER
	//BOOL OnOCEditorKey(Control oCntrl, UINT msg, UINT wParam, UINT lParam);
	///End REMOVE_FUNCTION_BROWER
	BOOL OnOCEditorChange(Control oCntrl);
	//virtual
	int GetBottomPaneSubControls(vector<uint>& vnCntrls)
	{
		vnCntrls.SetSize(0);
		vnCntrls.Add(IDC_XF_OUTPUT);
		vnCntrls.Add(IDC_XF_COMPILER_OUTPUT);
		return m_BottomTab.GetCurSel();
	}
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition); //CPY 4/30/05 MOVE_ROW_NEED_UPDATE_IDS
	//virtual 
	//void PositionTopPaneMainItem(Control& cMainItem, RECT& rMain, int cx, uint nMainItemID);
	//virtual 
	bool GetTopPaneControls(vector<uint>& vnTopDownIDs, vector& vdHeightRatios);
	//virtual 
	void PositionTopPaneMainItem(Control& cMainItem, RECT& rMain, int cx, uint nMainItemID)
	{
		m_rTopPaneMain = rMain;
		MultiPaneDlg::PositionTopPaneMainItem(cMainItem, rMain, cx, nMainItemID);
	}
	//virtual 
	int GetTopPaneMainID();
	
	int ShowContextMenu(TreeNode &trRow, TreeNode &trFunction, int nx, int ny, HWND hWndParent, int nRow, bool bFODlg=true, bool bAdvanView = true);	///Jasmine 01/24/06 SHOW_XF_CONTEXT_MENU
	bool OnShowMenu(UINT nResIDCtrl, int nx, int ny);
	
	BOOL OnSelMostRecentFileList(int nID);
	
	BOOL OnContentChange(Control ctrl);		//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	
	//BOOL OnKeyCmdWindow(Control oCntrl, UINT msg, UINT wParam, UINT lParam);	///---Frank 4/19/05	FIXED_ENTER_XF_NAME_AND_CODE_LOST

private:
	void updateXFFileName();	/// TD 2-28-05 QA70-7447 INTENAL_NAME)GENERATION
	int	 getInternalEditMode();
	bool isXFChanged();
	int	 getPathType();
	void clearXFChanged();
	void initXFTree();
	void setGridViewOptions(TreeNode& tr);
	void setTreeViewOptions(TreeNode& tr);
	//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	//void updateXFTreeToDlg(bool bRepositionControls = false);
	void updateXFTreeToDlg(bool bRepositionControls = false, bool bInitDlg = false);
	//------
	void updateDlgToXFTree();
	void updateDlgEditItemsToXFTree();
	void updateBottomTabDisplay(int nTabToShow = -1);
	void updateMessageLogTab() {}
	void updateCompilerOutputTab() {}
	void updateAutoUpdate();
	bool isAllowAutoUpdateExternal();
	bool isAutoUpdatePossible();
	bool isSaveToOperation(bool bAutoUpdateCheck, bool bExecuteButton);
	bool isInternalXF();//CPY 2/28/05
	bool resetLinkedOperation(bool bDelayed = true); //CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP
	bool isXFEmpty();
	bool isXFBasicallyEmpty();//--- CPY 3/31/05 SWITCH_TO_INTERNAL_WITH_DEFAULT_DLG_SHOULD_SET_TO_EMPTY
	bool isVarHasIO(bool bExcludeInputOutput=true);
	bool askCanExit();
	bool openXF(const string& strXFfile);
	/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
	void onAfterXFLoad(TreeNode& trXF);
	/// end CUSTOM_XF_DIALOGS
	bool outputOpMsgLog(LPCSTR lpcszMsg, bool bAddHeaderFooter = true)
	{
		if(bAddHeaderFooter)
		{
			m_reMsgLog.WriteSeparator(true , false);
			m_reMsgLog.WriteLine(" Testing");
		}
		m_reMsgLog.Write(lpcszMsg);
		m_reMsgLog.WriteLine();// empty line to make a separation
		return true;
	}
	void setViewAdvanced(int nSet = -1, bool bReDraw = true); // 0, 1, -1 to toggle
	bool isViewAdvanced()
	{
		return m_bViewAdvanced;
	}
	bool getFilename(string& strfilename, bool bFullpath = true, bool bInitIfEmpty = false);
	string getXFpath(bool bSaveAs = false);
	void redrawTopPaneFromTree();
#ifdef MAKE_SIMPER_XF_DLG
	void getViewBasicTopPaneIDs(vector<uint>& vn, int* ptopResizeItem=NULL);
#else
	void getViewBasicTopPaneIDs(vector<uint>& vn, int* ptopResizeItem=NULL, int* pbottomResizeItem=NULL);
#endif //MAKE_SIMPER_XF_DLG

	string getXFDisplayName();
	void updateDialogTitle();	///DG 1/20/05
	//string getCategoryName();	///DG 1/22/05 : move to XFO
	///DG 2/2/05
	void onBeforeShowFunction();
	void onBeforeSaveFunction();
	void expandBottomPane(int nTab = -1);
	bool onAfterCompile(bool bSuccess);
	void onFunctionChange(bool bUpdateGUI = true);
	void onChangeVarType(int nRow, int nCol);/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	void onChangeVarData(int nRow, int nCol);//CPY 2/28/05 2-28-05 QA70-7447 INTENAL_NAME_GENERATION
	void onChangeVarName(int nRow, int nCol); /// Hong 01/18/08 v8.0788 FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY

	/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
#ifdef	CUSTOM_XF_DIALOG
	void onChangeGetNOption(int nRow, int nCol);
#endif //	CUSTOM_XF_DIALOG
	/// end CUSTOM_XF_DIALOGS
	
	///end 2/2/05
	bool isRunSuccess();
	void updateShowButtons();
	void openFunctionBrowser();
	void setXFEmpty(bool bUpdateGUI=true);
	void newColXF(Worksheet& wks, int nCol, bool bUpdateGUI = true);
	bool editInternalXFfromOperation(UINT uidOp, Worksheet& wks, int nRow, int nCol, bool bColSelected);
	bool updateInternalXFtoOperation(bool bUpdateGUI, bool bCompile = false, bool bCheckExecuteSuccess = false);
	/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
	//bool updateOperation(OperationBase& op, XFunction& xf);
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	//	bool updateOperation(OperationBase& op, XFunction& xf, DataRange *pdrInput = NULL, DataRange *pdrOutput = NULL, BOOL bSetModified = TRUE);
	//bool updateOperation(OperationBase& op, XFunction& xf, DataRange *pdrInput = NULL, DataRange *pdrOutput = NULL, int nCntrl = OPSETXFUNCTION_SET_MODIFIED);
	/// end XFOPERATION_CHANGE_PARAM
	/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
	bool processXF(bool bCompile = true, bool bExecute = true, uint* pOPuid = NULL);
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	/*
	///Iris 3/29/05 ADD_RECENT_FILE_LIST
	HMENU getDlgMenu();
	bool initRecentFileListMenu(bool bSeparator = false);
	bool updateRecentFileListMenu(bool bAddSeparator = false);   
	bool insertFileList(bool bSeparator = false);
	bool removeAllFileList(bool bSeparator = false);
	bool addUpdateRecentFileList(LPCSTR lpcszFilePath);
	///end ADD_RECENT_FILE_LIST
	*/
	/// END ADD_RECENT_FILE_LIST
	
	///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
	bool	enlargeVariablesPane();
	bool	shrinkVariablesPane();
	void 	loadVariablePaneSize()
	{	
		if(!LoadSetting(VARI_PANE_REG_NAME, m_nTreeHeightPercent ) ||(m_nTreeHeightPercent <=VARIABLE_PANE_MIN_SIZE || m_nTreeHeightPercent >=VARIABLE_PANE_MAX_SIZE))
			m_nTreeHeightPercent = VARIABLE_PANE_STEP_INCRE * 4;
	}
	void saveVariablePaneSize()
	{	
		SaveSetting(VARI_PANE_REG_NAME, m_nTreeHeightPercent);
	}
	void checkCorrectXFGUINodes(TreeNode& trBranch);
	///End	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
	///---Frank 4/19/05	FIXED_ENTER_XF_NAME_AND_CODE_LOST
	//void	updateXFName();
	//void 	skipUpdateXFName();
	///---End	FIXED_ENTER_XF_NAME_AND_CODE_LOST
	
	BOOL openFile(string strInitPath, bool bKeepInReg = false);		//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
	
private:
//	XFunctionOrganizer	m_XFO;	///DG 1/19/05
	//RichEdit			m_reCode;
	CodeEdit			m_reCode;
	OperationLog		m_reMsgLog;
	RichEditEx			m_reCompilerOutput;
	bool				m_bViewAdvanced;
	RECT				m_rTopPaneMain;
	string				m_strXFdescription;
	Button				m_btnAutoUpdate;
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	Control				m_btnOK;
	Control				m_btnCancel;
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	//Control				m_btnOK;
	ComboBox			m_comboAttachTo;
	Edit				m_editXFname;
	Control				m_btnCompile;
	Control				m_btnRun;
	Control				m_staticXFnameLabel;
	bool				m_bRunSuccess;
	string				m_strInternalFilename; //CPY 2/28/05 2-28-05 QA70-7447 INTENAL_NAME_GENERATION
	int					m_nInternalMode;
	UINT				m_uidCurrentOp;
	bool				m_bIOChangedNeedOpReset;
	/*
	Worksheet			m_wksCurrent;
	int					m_nColCurrent;
	int					m_nRowCurrent;
	*/
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	//FileList			m_FileList;	///Iris 3/29/05 ADD_RECENT_FILE_LIST
	XFMRFList			m_MRFList;
	/// END ADD_RECENT_FILE_LIST_CLASS
	
	int 				m_nTreeHeightPercent; ///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	BOOL				m_bChangeParam;
	/// end XFOPERATION_CHANGE_PARAM
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	BOOL				m_bChangeParamOk;
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	/// TD 9-12-05 QA70-7403 XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
	BOOL				m_bSecondViewOpenInCodeBuilder;
	/// end XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
	
	bool		m_bDisableValDataInteractive;//----- CPY 3/15/06 XFDIALOG_FOR_DESIGN_TIME_ONLY
	DynaControl			m_DynaCntrl; //---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL

};


#endif //_XF_DLG_H

